<?php
    include 'header.php';
?>
  <!-- HERO -->
  <section class="hero-bg1 relative flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">About Us</h1>
      <p class="text-lg" data-aos="fade-up">Addressing the social, economic, and health challenges facing women and girls.</p>
    </div>
  </section>

  <!-- ABOUT SECTION -->
<section id="about" class="py-20 bg-gray-100 relative overflow-hidden">
  <div class="container mx-auto px-6">

    <!-- Section Title -->
    <h2 class="section-title text-3xl md:text-4xl font-bold mb-12 text-center" data-aos="fade-down">About Ekwendeni Women Dawa</h2>

    <!-- Paragraph + Video -->
    <div class="md:flex md:items-center md:space-x-12 mb-16">
      <!-- Text -->
      <div class="md:w-1/2 mb-8 md:mb-0" data-aos="fade-right">
        <p class="text-gray-700 text-lg text-justify">
          Ekwendeni Women Dawa Organization (EWDO), founded in 2019, is a dedicated non-profit committed to empowering women and promoting gender equality in the northern region and beyond. Through partnerships with local and international organizations, EWDO delivers programs in education, health awareness, and community development, aiming to transform lives by addressing the social, economic, and health challenges facing women and girls.
        </p>
      </div>

      <!-- YouTube Video -->
      <div class="md:w-1/2" data-aos="fade-left">
        <div class="aspect-w-16 aspect-h-9">
          <iframe class="w-full h-full rounded-lg shadow-lg" 
                  src="https://www.youtube.com/embed/YOUR_VIDEO_ID" 
                  title="Ekwendeni Women Dawa Video" 
                  frameborder="0" 
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                  allowfullscreen>
          </iframe>
        </div>
      </div>
    </div>

    <!-- Two-column Cards -->
    <div class="grid md:grid-cols-2 gap-8 mb-16">
      <!-- Left Column -->
      <div class="space-y-6">
        <div data-aos="fade-up" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-bullseye text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Mission</h3>
            <p class="text-gray-600">Empowering women and girls through education, advocacy, and support, nurturing gender equality and social justice.</p>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="100" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-eye text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Vision</h3>
            <p class="text-gray-600">Envisioning a world where every woman and girl flourishes in safe, inclusive spaces, enjoying equal access to opportunities and support while celebrating gender equality and diversity.</p>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="200" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-list-check text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Objectives</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Empowerment of girls & women.</li>
              <li>Addressing gender-based violence.</li>
              <li>Enhancing education & health.</li>
              <li>Facilitating personal & professional development.</li>
              <li>Providing community support.</li>
            </ul>
          </div>
        </div>
      </div>

      <!-- Right Column -->
      <div class="space-y-6">
        <div data-aos="fade-up" data-aos-delay="300" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-people-roof text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Scope of Work</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Conducting workshops and training for women and youth.</li>
              <li>Health awareness campaigns in communities.</li>
              <li>Providing mentorship and skill-building programs.</li>
              <li>Partnering with local organizations for sustainable development.</li>
              <li>Community outreach for advocacy and education.</li>
            </ul>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="400" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-bullhorn text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Targets</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Reach 500 women and girls annually through training programs.</li>
              <li>Raise awareness about health and gender issues in 50 communities.</li>
              <li>Support young women in pursuing education and entrepreneurship.</li>
              <li>Build partnerships with at least 10 organizations every year.</li>
              <li>Promote sustainable social and economic growth in local communities.</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>

<?php
    include 'footer.php';
?>
