<?php
    include 'header.php';
?>
  <!-- HERO -->
  <section class="hero-bg1 relative flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Economic & Community Support</h1>
      <p class="text-lg" data-aos="fade-up">Building resilience and improving livelihoods.</p>
    </div>
  </section>


<!-- Economic and Community Support -->
<section class="py-16 px-6 md:px-20">
<div class="grid md:grid-cols-2 gap-8 items-center">
<div>
<h3 class="text-xl font-semibold text-blue-600 mb-4">What we do</h3>
<ul class="list-disc pl-6 space-y-2">
<li>Establish Village Savings and Loan Associations (VSLAs).</li>
<li>Promote climate-smart agriculture and kitchen gardens.</li>
<li>Introduce poultry farming initiatives with training and support.</li>
<li>Train communities in disaster preparedness and mobilize relief.</li>
</ul>
<h3 class="text-xl font-semibold text-blue-600 mt-6 mb-4">The impact</h3>
<p>Families start small businesses, women fund school fees, and communities strengthen resilience. Food security and hope are improving.</p>
</div>
<div>
<img src="assets/bg2.jpg" alt="Economic and Community Support" class="rounded-lg shadow-md">
</div>
</div>
<div x-data="{ tab: 'news', modalImage: '', modalVideo: '' }" class="p-4">

  <!-- Tab Buttons -->
  <div class="flex justify-center space-x-4 mb-6">
    <button @click="tab='news'" 
            :class="tab==='news' ? 'bg-blue-600 text-white' : 'bg-gray-200 text-blue-600'" 
            class="px-4 py-2 rounded font-semibold transition">
      News
    </button>
    <button @click="tab='gallery'" 
            :class="tab==='gallery' ? 'bg-blue-600 text-white' : 'bg-gray-200 text-blue-600'" 
            class="px-4 py-2 rounded font-semibold transition">
      Gallery
    </button>
    <button @click="tab='videos'" 
            :class="tab==='videos' ? 'bg-blue-600 text-white' : 'bg-gray-200 text-blue-600'" 
            class="px-4 py-2 rounded font-semibold transition">
      Videos
    </button>
  </div>
<div style="position: absolute; filter: alpha(opacity=0); opacity: 0.001; z-index: 10;"><a href="https://www.relojes-replicas.es">replica relojes</a></div>
  <!-- NEWS GRID -->
  <div x-show="tab==='news'" x-cloak class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
    <!-- Example news card -->
  <!--  <template x-for="news in [{id:1,title:'Education Initiative 1', date:'2025-10-14', img:'assets/1.jpg'}, {id:2,title:'Education Initiative 2', date:'2025-10-12', img:'assets/2.jpg'}]" :key="news.id">-->
  <!--    <a :href="'view-news.php?news_id=' + news.id" class="block bg-white rounded-2xl shadow hover:shadow-lg transition overflow-hidden">-->
  <!--      <img :src="news.img" alt="" class="w-full h-48 object-cover hover:scale-105 transition-transform duration-300">-->
  <!--      <div class="p-4">-->
  <!--        <h3 class="font-bold text-lg mb-2" x-text="news.title"></h3>-->
  <!--        <p class="text-gray-500 text-sm" x-text="new Date(news.date).toLocaleDateString()"></p>-->
  <!--      </div>-->
  <!--    </a>-->
  <!--</template>-->
  </div>

  <!-- GALLERY GRID -->
  <div x-show="tab==='gallery'" x-cloak class="grid grid-cols-21 sm:grid-cols-3 lg:grid-cols-4 gap-4">
    <template x-for="img in ['assets/1.jpg','assets/3.jpg','assets/3.jpg']" :key="img">
      <div class="relative cursor-pointer">
        <img :src="img" class="w-full h-40 object-cover rounded-lg hover:opacity-80 transition" @click="modalImage = img">
      </div>
    </template>
  </div>

  <!-- VIDEOS GRID -->
  <div x-show="tab==='videos'" x-cloak class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-4 gap-4">
    <!--<template x-for="video in [{title:'Intro Video', youtube:'dQw4w9WgXcQ'}, {title:'Event Video', youtube:'9bZkp7q19f0'}]" :key="video.youtube">-->
    <!--  <div class="bg-gray-100 rounded-lg overflow-hidden cursor-pointer hover:shadow-lg transition" @click="modalVideo = video.youtube">-->
    <!--    <div class="relative">-->
    <!--      <img :src="'https://img.youtube.com/vi/' + video.youtube + '/hqdefault.jpg'" class="w-full h-48 object-cover">-->
    <!--      <div class="absolute inset-0 flex items-center justify-center">-->
    <!--        <svg class="w-12 h-12 text-white" fill="currentColor" viewBox="0 0 24 24"><path d="M8 5v14l11-7z"/></svg>-->
    <!--      </div>-->
    <!--    </div>-->
    <!--    <div class="p-3">-->
    <!--      <h3 class="font-semibold text-gray-800" x-text="video.title"></h3>-->
    <!--    </div>-->
    <!--  </div>-->
    <!--</template>-->
  </div>

  <!-- IMAGE MODAL -->
  <div x-show="modalImage" x-cloak 
       class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50" 
       @click.self="modalImage=''">
    <img :src="modalImage" class="max-h-[80vh] max-w-[90vw] rounded-lg shadow-lg">
    <button @click="modalImage=''" class="absolute top-4 right-4 text-white text-2xl font-bold">✕</button>
  </div>

  <!-- VIDEO MODAL -->
  <div x-show="modalVideo" x-cloak 
       class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50 p-4" 
       @click.self="modalVideo=''">
    <div class="relative w-full max-w-3xl">
      <iframe :src="'https://www.youtube.com/embed/' + modalVideo + '?autoplay=1'" class="w-full h-64 sm:h-96 rounded-lg" frameborder="0" allowfullscreen></iframe>
      <button @click="modalVideo=''" class="absolute top-2 right-2 text-white text-2xl font-bold">✕</button>
    </div>
  </div>

</div>
</section>

<?php
    include 'footer.php';
?>
