<?php
    include 'header.php';
?>
  <!-- HERO -->
  <section class="relative h-64 flex items-center justify-center text-center text-white"
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('https://images.unsplash.com/photo-1521791136064-7986c2920216?auto=format&fit=crop&w=1400&q=80'); background-size:cover; background-position:center;">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Contact Us</h1>
      <p class="text-lg" data-aos="fade-up">We’d love to hear from you</p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.html" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold">Contact Us</li>
    </ol>
  </nav>

  <!-- CONTACT SECTION -->
  <section class="py-20 bg-white">
    <div class="container mx-auto px-6 grid md:grid-cols-2 gap-12">

      <!-- Contact Info -->
      <div data-aos="fade-right">
        <h2 class="section-title text-3xl md:text-4xl font-bold mb-6">Get In Touch</h2>
        <p class="text-gray-600 mb-6">Whether you want to volunteer, donate, or simply learn more about our work, we’re here to connect with you.</p>
        
        <ul class="space-y-4 text-gray-700">
          <li><strong><i class="fa-solid fa-location-dot mr-2"></i></strong> Mzuzu, Malawi</li>
          <li><strong><i class="fa-solid fa-envelope mr-2"></i></strong> <a href="mailto:info@ewdomw.org" class="text-brand hover:underline">info@ewdomw.org</a></li>
          <li><strong><i class="fa-solid fa-phone mr-2"></i></strong> +265 886 090 669</li>
        </ul>
      </div>

      <!-- Contact Form -->
      <div data-aos="fade-left">
        <form action="#" method="POST" class="bg-gray-50 shadow-lg rounded-xl p-8">
          <div class="mb-4">
            <label class="block text-gray-700 mb-2">Full Name</label>
            <input type="text" name="name" class="w-full border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brand" required>
          </div>
          <div class="mb-4">
            <label class="block text-gray-700 mb-2">Email</label>
            <input type="email" name="email" class="w-full border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brand" required>
          </div>
          <div class="mb-4">
            <label class="block text-gray-700 mb-2">Message</label>
            <textarea name="message" rows="5" class="w-full border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brand" required></textarea>
          </div>
          <button type="submit" class="btn-primary w-full">Send Message</button>
        </form>
      </div>
    </div>
  </section>

  <!-- MAP SECTION -->
  <section class="h-96">
    <iframe
      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3948.123456789!2d34.0156!3d-11.4590!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x196b8b2a1f234567%3A0xabcdef1234567890!2sChipiku%20Plus%2C%20Mzuzu%2C%20Malawi!5e0!3m2!1sen!2smw!4v1690000000000"
      width="100%"
      height="100%"
      style="border:0;"
      allowfullscreen=""
      loading="lazy">
    </iframe>
  </section>

<?php
    include 'footer.php';
?>
