<?php
    include 'header.php';
?>
<style> 
    input[type="number"] {border:1px solid #0ea5e9; padding:0.5rem; border-radius:0.5rem; width:100%;}
</style>
  <!-- HERO -->
  <section class="relative h-64 flex items-center justify-center text-center text-white"
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('https://images.unsplash.com/photo-1588776814546-c4c42e75cd56?auto=format&fit=crop&w=1400&q=80'); background-size:cover; background-position:center;">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Support Our Cause</h1>
      <p class="text-lg" data-aos="fade-up">Empower Women & Girls</p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.html" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold">Donate</li>
    </ol>
  </nav>

  <!-- DONATE SECTION -->
  <section class="py-20 bg-white">
    <div class="container mx-auto px-6 md:w-2/3">
      <h2 class="section-title text-3xl md:text-4xl font-bold text-center mb-12">Make a Donation</h2>

      <p class="text-gray-700 text-lg mb-8 text-center">Your contribution helps empower women and support community programs across northern Malawi. Every donation counts!</p>

      <!-- Donation Form -->
      <form class="bg-gray-50 p-8 rounded-xl shadow-lg" data-aos="fade-up">
        
        <!-- Preset Amounts -->
        <div class="mb-6">
          <label class="block font-semibold mb-2 text-gray-700">Select Amount</label>
          <div class="flex space-x-4">
            <button type="button" class="btn-primary px-6 py-2" onclick="document.getElementById('customAmount').value=50;">$50</button>
            <button type="button" class="btn-primary px-6 py-2" onclick="document.getElementById('customAmount').value=100;">$100</button>
            <button type="button" class="btn-primary px-6 py-2" onclick="document.getElementById('customAmount').value=200;">$200</button>
          </div>
        </div>

        <!-- Custom Amount -->
        <div class="mb-6">
          <label class="block font-semibold mb-2 text-gray-700">Or Enter Custom Amount</label>
          <input type="number" id="customAmount" name="amount" placeholder="$0" min="1" required>
        </div>

        <!-- Payment Methods -->
        <div class="mb-6">
          <label class="block font-semibold mb-2 text-gray-700">Payment Method</label>
          <select class="w-full border border-gray-300 rounded p-2" required>
            <option value="">Select Payment Method</option>
            <option value="paypal">PayPal</option>
            <option value="bank">Bank Transfer</option>
            <option value="mobile-money">Mobile Money</option>
          </select>
        </div>

        <!-- Donate Button -->
        <div class="text-center">
          <button type="submit" class="btn-primary w-full md:w-auto">Donate Now</button>
        </div>
      </form>

      <!-- Impact Statement -->
      <div class="mt-16 text-center" data-aos="fade-up">
        <h3 class="font-bold text-2xl mb-4">Your Contribution Makes a Difference</h3>
        <p class="text-gray-700 text-lg">Every donation helps empower women, support cooperative projects, and provide essential community health programs. Together, we can create lasting impact in northern Malawi.</p>
      </div>
    </div>
  </section>
<?php
    include 'footer.php';
?>