
<!-- FOOTER -->
<footer class="bg-gray-800 text-gray-200 py-12">
  <div class="container mx-auto px-6 md:flex md:justify-between md:items-start gap-8">
    
    <!-- About / Info -->
    <div class="md:w-1/3 mb-6 md:mb-0" data-aos="fade-up">
      <h4 class="text-lg font-semibold text-white mb-3">Ekwendeni Women Dawa Organisation</h4>
      <p class="text-gray-400 text-sm">
        Empowering women and girls through education, advocacy, and support, nurturing gender equality and social justice.
      </p>
      <div class="flex mt-4 space-x-3 text-xl">
        <a href="https://www.facebook.com/profile.php?id=100092235896088" class="hover:text-white transition">
          <i class="fab fa-facebook-f"></i>
        </a>
        <a href="https://www.linkedin.com/company/ekwendeni-women-dawa-organization/?lipi=urn%3Ali%3Apage%3Ad_flagship3_search_srp_all%3BJ2XxfBg%2BSPSo321ITIFjAg%3D%3D" class="hover:text-white transition">
          <i class="fab fa-linkedin-in"></i>
        </a>
        <a href="https://www.youtube.com/@ewdomw" class="hover:text-white transition">
          <i class="fab fa-youtube"></i>
        </a>
        <a href="#" class="hover:text-white transition">
          <i class="fab fa-instagram"></i>
        </a>
      </div>
    </div>
    
    <!-- Quick Links -->
    <div class="md:w-1/3 mb-6 md:mb-0" data-aos="fade-up" data-aos-delay="100">
      <h4 class="text-lg font-semibold text-white mb-3">Quick Links</h4>
      <ul class="text-gray-400 text-sm space-y-2">
        <li><a href="about.php" class="hover:text-white transition">About Us</a></li>
        <li><a href="events.php" class="hover:text-white transition">Events</a></li>
        <li><a href="new.php" class="hover:text-white transition">News</a></li>
        <li><a href="contact.php" class="hover:text-white transition">Contact</a></li>
        <li><a href="donate.php" class="hover:text-white transition">Donate</a></li>
        <!-- <li><a href="privacy.php" class="hover:text-white transition">Privacy</a></li> -->
      </ul>
    </div>

    <!-- Quick Links -->
    <div class="md:w-1/3 mb-6 md:mb-0" data-aos="fade-up" data-aos-delay="150">
      <h4 class="text-lg font-semibold text-white mb-3">Policies</h4>
      <ul class="text-gray-400 text-sm space-y-2">
        <li><a href="assets/safeguarding-policy.pdf" target="_blank" class="hover:text-white transition">Safeguarding Policy</a></li>
        <li><a href="assets/whistleblower.pdf" target="_blank" class="hover:text-white transition">Whistleblower Policy</a></li>
        <li><a href="assets/privacy-policy.pdf" target="_blank" class="hover:text-white transition">Privacy Policy</a></li>
      </ul>
    </div>

    <!-- what we do -->
    <div class="md:w-1/3 mb-6 md:mb-0" data-aos="fade-up" data-aos-delay="200">
      <h4 class="text-lg font-semibold text-white mb-3">What we do</h4>
      <ul class="text-gray-400 text-sm space-y-2">
        <li><a href="education.php" class="hover:text-white transition">Education & Skill Development</a></li>
        <li><a href="community-support.php" class="hover:text-white transition">Economic & Community Support</a></li>
        <li><a href="gbv.php" class="hover:text-white transition">Addressing GBV</a></li>
        <li><a href="health.php" class="hover:text-white transition">Health & Well Being</a></li>
        <li><a href="entrepreneurship.php" class="hover:text-white transition">Entrepreneurship</a></li>
      </ul>
    </div>

    <!-- Contact -->
    <div class="md:w-1/3" data-aos="fade-up" data-aos-delay="250">
      <h4 class="text-lg font-semibold text-white mb-3">Contact</h4>
      <p class="text-gray-400 text-sm"><i class="fa-solid fa-phone mr-2 text-white"></i> +265 886 090 669</p>
      <p class="text-gray-400 text-sm mt-2"><i class="fa-solid fa-envelope mr-2 text-white"></i> info@ewdomw.org</p>
      <p class="text-gray-400 text-sm mt-2"><i class="fa-solid fa-location-dot mr-2 text-white"></i> Mzuzu, Malawi</p>
    </div>

  </div>
  <!-- Copyright & Powered by -->
  <div class="mt-12 border-t border-gray-700 pt-4 text-center text-sm text-gray-500" data-aos="fade-up" data-aos-delay="300">
    © 2025 Ekwendeni Women Dawa Organisation. All rights reserved.  
    <br>
    Powered by <a href="mailto:ozonedynamics1@gmail.com" class="hover:text-white underline">Ozone Dynamics</a>
  </div>
</footer>


  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script src="https://unpkg.com/alpinejs" defer></script>
  <script>
  // Function to toggle dropdowns on mobile
  function toggleDropdown(id) {
    const dropdown = document.getElementById(id);
    dropdown.classList.toggle('hidden');
  }
</script>
  <script>
    $(document).ready(function(){
      $('.owl-carousel').owlCarousel({loop:true, margin:10, nav:true, items:1, autoplay:true, autoplayTimeout:5000});
    });
    AOS.init({duration:1000, once:true});

    document.getElementById('nav-toggle').addEventListener('click', function(){
      const m = document.getElementById('mobile-menu');
      m.classList.toggle('hidden');
    });
  </script>
  <!-- Owl Carousel & AOS Scripts -->
<script>
  $(document).ready(function(){
    $('.owl-carousel').owlCarousel({
      loop:true,
      margin:0,
      nav:true,
      items:1,
      autoplay:true,
      autoplayTimeout:6000,
      autoplayHoverPause:true,
      animateOut: 'fadeOut',
      animateIn: 'fadeIn'
    });
  });
  AOS.init({duration:1000, once:true});
</script>

<script>
// Animated counters
const counters = document.querySelectorAll('.counter');
const speed = 200; // lower = faster

counters.forEach(counter => {
  const updateCount = () => {
    const target = +counter.getAttribute('data-target');
    const count = +counter.innerText;
    const increment = target / speed;

    if (count < target) {
      counter.innerText = Math.ceil(count + increment);
      requestAnimationFrame(updateCount);
    } else {
      counter.innerText = target;
    }
  };

  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        updateCount();
        observer.unobserve(counter); // run once
      }
    });
  }, {threshold: 0.6});

  observer.observe(counter);
});
</script>
</body>
</html>
