<?php
    include 'header.php';
?>
  <!-- HERO -->
  <section class="hero-bg1 relative flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Gallery</h1>
      <p class="text-lg" data-aos="fade-up"></p>
    </div>
  </section>

  <!-- GALLERY SECTION -->
<section class="py-20 bg-gray-50">
  <div class="container mx-auto px-6">
    <div class="grid md:grid-cols-3 gap-6">
      
      <!-- Gallery Item -->
      <div class="relative group cursor-pointer" onclick="openGalleryModal('assets/1.jpg')">
        <img src="assets/1.jpg" alt="Gallery Image" class="w-full h-64 object-cover rounded-lg shadow-lg">
        
        <!-- Hover Overlay -->
        <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
          <i class="fas fa-search text-white text-3xl"></i>
        </div>
      </div>

      <!-- Gallery Item -->
      <div class="relative group cursor-pointer" onclick="openGalleryModal('assets/2.jpg')">
        <img src="assets/2.jpg" alt="Gallery Image" class="w-full h-64 object-cover rounded-lg shadow-lg">
        <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
          <i class="fas fa-search text-white text-3xl"></i>
        </div>
      </div>

      <!-- Gallery Item -->
      <div class="relative group cursor-pointer" onclick="openGalleryModal('assets/3.jpg')">
        <img src="assets/3.jpg" alt="Gallery Image" class="w-full h-64 object-cover rounded-lg shadow-lg">
        <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
          <i class="fas fa-search text-white text-3xl"></i>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- Image Modal -->
<div id="imageModal" class="fixed inset-0 bg-black bg-opacity-80 hidden flex items-center justify-center z-50">
  <span class="absolute top-5 right-5 text-white text-3xl cursor-pointer" onclick="closeGalleryModal()">&times;</span>
  <img id="modalImg" class="max-w-3xl w-full rounded-lg shadow-lg">
</div>

<script>
function openGalleryModal(src) {
  document.getElementById("modalImg").src = src;
  document.getElementById("imageModal").classList.remove("hidden");
}
function closeGalleryModal() {
  document.getElementById("imageModal").classList.add("hidden");
}
</script>
<?php
    include 'footer.php';
?>
