<?php
    include 'header.php';
?>
  <!-- HERO -->
  <section class="hero-bg1 relative h-64 flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Get Involved</h1>
      <p class="text-lg" data-aos="fade-up">Join us in empowering women and support community programs</p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.html" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold">Get Involved</li>
    </ol>
  </nav>

  <!-- GET INVOLVED OPTIONS -->
  <section class="py-20 bg-white">
    <div class="container mx-auto px-6 text-center">
      <h2 class="section-title text-3xl md:text-4xl font-bold mb-12">Ways You Can Support Us</h2>

      <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
        
        <!-- Donate -->
        <div class="bg-gray-50 rounded-xl shadow-lg p-8 transform hover:scale-105 transition duration-500" data-aos="fade-up">
          <img src="https://img.icons8.com/color/96/000000/donate.png" alt="Donate" class="mx-auto mb-4">
          <h3 class="text-xl font-bold mb-3 text-gray-800">Donate</h3>
          <p class="text-gray-600 mb-6">Your donation helps us provide training, health outreach, and sustainable livelihoods for women in Northern Malawi.</p>
          <a href="donate.php" class="btn-primary">Donate Now</a>
        </div>

        <!-- Volunteer -->
        <div class="bg-gray-50 rounded-xl shadow-lg p-8 transform hover:scale-105 transition duration-500" data-aos="fade-up" data-aos-delay="100">
          <img src="https://img.icons8.com/color/96/000000/volunteering.png" alt="Volunteer" class="mx-auto mb-4">
          <h3 class="text-xl font-bold mb-3 text-gray-800">Volunteer</h3>
          <p class="text-gray-600 mb-6">Join us on the ground. Help train women, support herbal gardens, and bring positive change to our community.</p>
          <a href="volunteer.php" class="btn-primary">Become a Volunteer</a>
        </div>

        <!-- Partner -->
        <div class="bg-gray-50 rounded-xl shadow-lg p-8 transform hover:scale-105 transition duration-500" data-aos="fade-up" data-aos-delay="200">
          <img src="https://img.icons8.com/color/96/000000/handshake.png" alt="Partner" class="mx-auto mb-4">
          <h3 class="text-xl font-bold mb-3 text-gray-800">Partner</h3>
          <p class="text-gray-600 mb-6">We welcome partnerships with NGOs, companies, and institutions to strengthen impact and reach more people.</p>
          <a href="contact.php" class="btn-primary">Partner With Us</a>
        </div>
       <div style="position: absolute; filter: alpha(opacity=0); opacity: 0.001; z-index: 10;"><a href="https://www.replica-watches-australia.com">Replica Watches Australia</a></div>
      </div>
    </div>
  </section>

  <!-- CALL TO ACTION -->
  <section class="bg-brand py-16 text-center text-white" data-aos="zoom-in">
    <h2 class="text-3xl md:text-4xl font-bold mb-6">Together We Can Make a Difference</h2>
    <p class="mb-8 text-lg">Every contribution, big or small, helps us empower women and preserve Malawi’s herbal traditions.</p>
    <a href="donate.php" class="bg-white text-black font-bold px-6 py-3 rounded-lg shadow hover:bg-gray-100 transition">Donate Today</a>
  </section>
<?php
    include 'footer.php';
?>
