<?php
    include 'config/config.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Ekwendeni Women Dawa Organisation</title>
  <meta name="description" content="Ekwendeni Women Dawa Organisation — empowering women and supporting community wellbeing." />

  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    /* body {scroll-behavior: smooth;}
    .hero-bg{background-image:linear-gradient(rgba(0,0,0,0.35), rgba(0,0,0,0.35)), url('https://images.unsplash.com/photo-1503342452485-86f7b7a3b420?auto=format&fit=crop&w=1400&q=60'); background-size:cover; background-position:center}
    .brand-color{color:#0ea5e9}
    .bg-brand{background-color:#0ea5e9}
    .border-brand{border-color:#0ea5e9}
    .btn-primary {background-color:#0ea5e9; color:white; padding:0.75rem 1.5rem; border-radius:0.5rem; font-weight:600; box-shadow:0 4px 6px rgba(0,0,0,0.1); transition: transform 0.3s, background-color 0.3s;}
    .btn-primary:hover {background-color:#0284c7; transform:scale(1.05);}
    .section-title {font-size:2rem; font-weight:700; color:#0ea5e9; margin-bottom:1rem;}
    .program-card img {transition: transform 0.5s ease, opacity 0.5s ease;}
    .program-card:hover img {transform: scale(1.05); opacity:0.9;} */

    /* Smooth scroll for anchor links */
    body { scroll-behavior: smooth; font-family: 'Inter', sans-serif; }

    /* Hero section with overlay */
    .hero-bg {
        background-image: linear-gradient(rgba(0, 0, 0, 0.35), rgba(0, 0, 0, 0.35)), 
                        url('https://images.unsplash.com/photo-1503342452485-86f7b7a3b420?auto=format&fit=crop&w=1400&q=60');
        background-size: cover;
        background-position: center;
        min-height: 70vh; /* Adjusted for smaller hero */
        display: flex;
        align-items: center;
    }

    /* Hero section with overlay */
    .hero-bg1 {
        background-image:linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.7)), url('assets/1.jpg'); 
        background-size:cover; 
        background-position:center;
        min-height: 30vh; /* Adjusted for smaller hero */
        display: flex;
        align-items: center;
    }

    /* Brand colors */
    .brand-color { color: #0ea5e9; }
    .bg-brand { background-color: #0ea5e9; }
    .border-brand { border-color: #0ea5e9; }

    /* Primary button */
    .btn-primary {
        background-color: #0ea5e9; 
        color: white; 
        padding: 0.75rem 1.5rem; 
        border-radius: 0.5rem; 
        font-weight: 600; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.1); 
        transition: transform 0.3s, background-color 0.3s;
        display: inline-block;
    }
    .btn-primary:hover {
        background-color: #0284c7; 
        transform: scale(1.05);
    }

    /* Section titles */
    .section-title {
        font-size: 2rem; 
        font-weight: 700; 
        color: #0ea5e9; 
        margin-bottom: 1rem;
    }

    /* Program cards */
    .program-card img {
        transition: transform 0.5s ease, opacity 0.5s ease;
        border-radius: 0.5rem;
    }
    .program-card:hover img {
        transform: scale(1.05); 
        opacity: 0.9;
    }

    /* Mobile menu buttons */
    #mobile-menu button {
        font-weight: 600;
        color: #0ea5e9;
        background-color: white;
        padding: 0.5rem 0.75rem;
        border-radius: 0.375rem;
        width: 100%;
        text-align: left;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: background-color 0.3s, color 0.3s;
    }
    #mobile-menu button:hover {
        background-color: #0ea5e9;
        color: white;
    }

    /* Footer links hover */
    footer a:hover {
        color: #0ea5e9;
    }

    /* Impact section counters */
    .counter {
        font-size: 2rem; 
        font-weight: 700; 
        color: #0ea5e9;
    }
  </style>
</head>
<body class="antialiased text-gray-800">

  <!-- TOP HEADER -->
  <div class="bg-brand text-white text-sm py-2">
    <div class="container mx-auto px-6 flex justify-between">
      <div><i class="fa-solid fa-phone mr-2 text-white"></i> +265 886 090 669 | <i class="fa-solid fa-envelope mx-2 text-white"></i> info@ewdomw.org</div>
      <div>
        <a href="https://www.facebook.com/profile.php?id=100092235896088" class="underline"><i class="fab fa-facebook-f"></i></a> | 
        <a href="https://www.linkedin.com/company/ekwendeni-women-dawa-organization/?lipi=urn%3Ali%3Apage%3Ad_flagship3_search_srp_all%3BJ2XxfBg%2BSPSo321ITIFjAg%3D%3D" class="underline"><i class="fab fa-linkedin-in"></i></a> | 
        <a href="https://www.youtube.com/@ewdomw" class="underline"><i class="fab fa-youtube"></i></a> | 
        <a href="#" class="underline"><i class="fab fa-instagram"></i></a>
      </div>
    </div>
  </div>

  <!-- NAV -->
  <header class="bg-white shadow sticky top-0 z-50">
    <div class="container mx-auto px-6 py-4 flex items-center justify-between">
      <a href="index.php" class="flex items-center space-x-3">
        <div class="w-20 h-20 rounded-full flex items-center justify-center text-white font-bold"><img src="assets/EWDO.png" alt=""></div>
        <div>
          <h1 class="text-lg font-semibold">Ekwendeni Women Dawa</h1>
          <p class="text-xs text-gray-500">Empowering women & girls</p>
        </div>
      </a>

      <nav class="hidden md:flex items-center space-x-6 text-sm">
        <div class="relative group">
          <button class="hover:text-blue-500 focus:outline-none">About Us ▾</button>
          <div class="absolute left-0 mt-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300 bg-white border rounded shadow-md w-40">
            <a href="about.php" class="block px-4 py-2 hover:text-blue-500">Who We Are</a>
            <!-- <a href="team.php" class="block px-4 py-2 hover:text-blue-500">Our Team</a> -->
            <a href="careers.php" class="block px-4 py-2 hover:text-blue-500">Careers</a>
            <a href="gallery.php" class="block px-4 py-2 hover:text-blue-500">Gallery</a>
            <a href="videos.php" class="block px-4 py-2 hover:text-blue-500">Videos</a>
          </div>
        </div>

        <div class="relative group">
          <button class="hover:text-blue-500 focus:outline-none">Our Work ▾</button>
          <div class="absolute left-0 mt-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300 bg-white border rounded shadow-md w-44">
            <a href="education.php" class="block px-4 py-2 hover:text-blue-500">Education & Skill Development</a>
            <a href="community-support.php" class="block px-4 py-2 hover:text-blue-500">Economic & Community Support</a>
            <a href="gbv.php" class="block px-4 py-2 hover:text-blue-500">Addressing Gender-Based Violence</a>
            <a href="entrepreneurship.php" class="block px-4 py-2 hover:text-blue-500">Entrepreneurship</a>
            <a href="health.php" class="block px-4 py-2 hover:text-blue-500">Health & Well Being</a>
          </div>
        </div>

        <a href="events.php" class="hover:text-blue-500">Events</a>
        <a href="news.php" class="hover:text-blue-500">News</a>
        <a href="getinvolved.php" class="hover:text-blue-500">Get Involved</a>
        <a href="contact.php" class="hover:text-blue-500">Contact</a>
        <a href="donate.php" class="btn-primary">Donate</a>
      </nav>

      <button class="md:hidden text-2xl" id="nav-toggle">☰</button>
    </div>

    <!-- MOBILE MENU -->
    <div id="mobile-menu" class="md:hidden hidden px-6 pb-4">
        <!-- About Us Dropdown -->
        <div class="mb-2">
            <button class="w-full text-left py-2 font-semibold flex justify-between items-center" onclick="toggleDropdown('about-dropdown')">
            About Us ▾
            </button>
            <div id="about-dropdown" class="hidden pl-4 mt-1 space-y-1">
              <a href="about.php" class="block px-2 py-1 hover:text-blue-500">Who We Are</a>
              <a href="team.php" class="block px-2 py-1 hover:text-blue-500">Our Team</a>
              <a href="careers.php" class="block px-2 py-1 hover:text-blue-500">Careers</a>
              <a href="gallery.php" class="block px-2 py-1 hover:text-blue-500">Gallery</a>
              <a href="videos.php" class="block px-2 py-1 hover:text-blue-500">Videos</a>
            </div>
        </div>

        <!-- Our Work Dropdown -->
        <div class="mb-2">
            <button class="w-full text-left py-2 font-semibold flex justify-between items-center" onclick="toggleDropdown('work-dropdown')">
            Our Work ▾
            </button>
            <div id="work-dropdown" class="hidden pl-4 mt-1 space-y-1">
              <a href="education.php" class="block px-2 py-1 hover:bg-gray-100">Education</a>
              <a href="community-support.php" class="block px-2 py-1 hover:bg-gray-100">Economic & Community Support</a>
              <a href="gbv.php" class="block px-2 py-1 hover:bg-gray-100">Addressing GBV</a>
              <a href="entrepreneurship.php" class="block px-2 py-1 hover:bg-gray-100">Entrepreneurship</a>
              <a href="health.php" class="block px-2 py-1 hover:bg-gray-100">Health & Well Being</a>
            </div>
        </div>

        <!-- Other Links -->
        <a href="#news" class="block px-2 py-2 hover:bg-gray-100">Events</a>
        <a href="#news" class="block px-2 py-2 hover:bg-gray-100">News</a>
        <a href="#news" class="block px-2 py-2 hover:bg-gray-100">Get Involved</a>
        <a href="#contact" class="block px-2 py-2 hover:bg-gray-100">Contact</a>
        <a href="donate.php" class="block px-2 py-2 font-bold text-white bg-brand text-center rounded hover:bg-gray-100">Donate</a>
    </div>
  </header>
