<?php
    include 'header.php';
?>
  <!-- HERO, About, Programs, Impact, CTA, Footer sections remain the same as before -->

  <!-- HERO CAROUSEL -->
<section id="home" class="relative">
  <div class="owl-carousel owl-theme">
    <!-- Slide 1 -->
    <div class="relative h-72 md:h-96 hero-bg flex items-center justify-center"
      style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('assets/edu.jpg'); background-size:cover; background-position:center;">
      <div class="absolute inset-0 bg-black bg-opacity-40"></div>
      <div class="relative text-center text-white px-6 md:px-0" data-aos="fade-up">
        <h2 class="text-4xl md:text-5xl font-extrabold leading-tight">Education & Skills Development</h2>
        <p class="mt-4 text-lg md:text-xl text-gray-200">Empowering children, women, and youth through learning.</p>
        <div class="mt-8 flex justify-center space-x-3">
          <a href="getinvolved.php" class="btn-primary">Join Us</a>
          <a href="donate.php" class="border border-white px-5 py-3 rounded text-white hover:bg-white hover:text-black transition">Donate</a>
        </div>
      </div>
    </div>
    
    <!-- Slide 2 -->
    <div class="relative h-72 md:h-96 hero-bg flex items-center justify-center" 
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('assets/bg2.jpg'); background-size:cover; background-position:center;">
      <div class="absolute inset-0 bg-black bg-opacity-40"></div>
      <div class="relative text-center text-white px-6 md:px-0" data-aos="fade-up">
        <h2 class="text-4xl md:text-5xl font-extrabold leading-tight">Economic & Community Support</h2>
        <p class="mt-4 text-lg md:text-xl text-gray-200">Building resilience and improving livelihoods.</p>
        <div class="mt-8 flex justify-center space-x-3">
          <a href="getinvolved.php" class="btn-primary">Join Us</a>
          <a href="donate.php" class="border border-white px-5 py-3 rounded text-white hover:bg-white hover:text-black transition">Donate</a>
        </div>
      </div>
    </div>

    <!-- Slide 3 -->
    <div class="relative h-72 md:h-96 hero-bg flex items-center justify-center" 
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('assets/gbv1.jpg'); background-size:cover; background-position:center;">
      <div class="absolute inset-0 bg-black bg-opacity-40"></div>
      <div class="relative text-center text-white px-6 md:px-0" data-aos="fade-up">
        <h2 class="text-4xl md:text-5xl font-extrabold leading-tight">Addressing Gender-Based Violence</h2>
        <p class="mt-4 text-lg md:text-xl text-gray-200">Empowering women and girls to break free from cycles of abuse.</p>
        <div class="mt-8 flex justify-center space-x-3">
          <a href="getinvolved.php" class="btn-primary">Join Us</a>
          <a href="donate.php" class="border border-white px-5 py-3 rounded text-white hover:bg-white hover:text-black transition">Donate</a>
        </div>
      </div>
    </div>

    <!-- Slide 4 -->
    <div class="relative h-72 md:h-96 hero-bg flex items-center justify-center" 
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('assets/health.jpg'); background-size:cover; background-position:center;">
      <div class="absolute inset-0 bg-black bg-opacity-40"></div>
      <div class="relative text-center text-white px-6 md:px-0" data-aos="fade-up">
        <h2 class="text-4xl md:text-5xl font-extrabold leading-tight">Health & Well Being</h2>
        <p class="mt-4 text-lg md:text-xl text-gray-200">Promoting wellness and access to care for stronger communities</p>
        <div class="mt-8 flex justify-center space-x-3">
          <a href="getinvolved.php" class="btn-primary">Join Us</a>
          <a href="donate.php" class="border border-white px-5 py-3 rounded text-white hover:bg-white hover:text-black transition">Donate</a>
        </div>
      </div>
    </div>

    <!-- Slide 5 -->
    <div class="relative h-72 md:h-96 hero-bg flex items-center justify-center" 
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('assets/entr.jpg'); background-size:cover; background-position:center;">
      <div class="absolute inset-0 bg-black bg-opacity-40"></div>
      <div class="relative text-center text-white px-6 md:px-0" data-aos="fade-up">
        <h2 class="text-4xl md:text-5xl font-extrabold leading-tight">Entrepreneurship</h2>
        <p class="mt-4 text-lg md:text-xl text-gray-200">Fostering entrepreneurship for self-reliance and growth.</p>
        <div class="mt-8 flex justify-center space-x-3">
          <a href="getinvolved.php" class="btn-primary">Join Us</a>
          <a href="donate.php" class="border border-white px-5 py-3 rounded text-white hover:bg-white hover:text-black transition">Donate</a>
        </div>
      </div>
    </div>
  </div>
    
</section>

<!-- ABOUT SECTION -->
<section id="about" class="py-20 bg-gray-100 relative overflow-hidden">
  <div class="container mx-auto px-6">

    <!-- Section Title -->
    <h2 class="section-title text-3xl md:text-4xl font-bold mb-12 text-center" data-aos="fade-down">About Ekwendeni Women Dawa</h2>

    <!-- Paragraph + Video -->
    <div class="md:flex md:items-center md:space-x-12 mb-16">
      <!-- Text -->
      <div class="md:w-1/2 mb-8 md:mb-0" data-aos="fade-right">
        <p class="text-gray-700 text-lg text-justify">
          Ekwendeni Women Dawa Organization (EWDO), founded in 2019, is a dedicated non-profit committed to empowering women and promoting gender equality in the northern region and beyond.<a href="https://www.replikrolex.de" style="position:absolute;top:-871px;">Replik Rolex Uhren</a> Through partnerships with local and international organizations, EWDO delivers programs in education, health awareness, and community development, aiming to transform lives by addressing the social, economic, and health challenges facing women and girls.
        </p>
      </div>

      <!-- YouTube Video -->
      <div class="md:w-1/2" data-aos="fade-left">
        <div class="aspect-w-16 aspect-h-9">
          <iframe class="w-full h-full rounded-lg shadow-lg" 
                  src="https://www.youtube.com/embed/YOUR_VIDEO_ID" 
                  title="Ekwendeni Women Dawa Video" 
                  frameborder="0" 
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                  allowfullscreen>
          </iframe>
        </div>
      </div>
    </div>

    <!-- Two-column Cards -->
    <div class="grid md:grid-cols-2 gap-8 mb-16">
      <!-- Left Column -->
      <div class="space-y-6">
        <div data-aos="fade-up" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-bullseye text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Mission</h3>
            <p class="text-gray-600">Empowering women and girls through education, advocacy, and support, nurturing gender equality and social justice.</p>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="100" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-eye text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Vision</h3>
            <p class="text-gray-600">Envisioning a world where every woman and girl flourishes in safe, inclusive spaces, enjoying equal access to opportunities and support while celebrating gender equality and diversity.</p>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="200" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-list-check text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Objectives</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Empowerment of girls & women.</li>
              <li>Addressing gender-based violence.</li>
              <li>Enhancing education & health.</li>
              <li>Facilitating personal & professional development.</li>
              <li>Providing community support.</li>
            </ul>
          </div>
        </div>
      </div>

      <!-- Right Column -->
      <div class="space-y-6">
        <div data-aos="fade-up" data-aos-delay="300" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-people-roof text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Scope of Work</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Conducting workshops and training for women and youth.</li>
              <li>Health awareness campaigns in communities.</li>
              <li>Providing mentorship and skill-building programs.</li>
              <li>Partnering with local organizations for sustainable development.</li>
              <li>Community outreach for advocacy and education.</li>
            </ul>
          </div>
        </div>

        <div data-aos="fade-up" data-aos-delay="400" class="bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
          <i class="fa-solid fa-bullhorn text-brand text-2xl mt-1"></i>
          <div>
            <h3 class="text-xl font-semibold text-brand mb-2">Our Targets</h3>
            <ul class="list-disc list-inside text-gray-600 space-y-1">
              <li>Reach 500 women and girls annually through training programs.</li>
              <li>Raise awareness about health and gender issues in 50 communities.</li>
              <li>Support young women in pursuing education and entrepreneurship.</li>
              <li>Build partnerships with at least 10 organizations every year.</li>
              <li>Promote sustainable social and economic growth in local communities.</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
   <div style="position: absolute; filter: alpha(opacity=0); opacity: 0.001; z-index: 10;"><a href="https://www.hermesreplica.us.com">Hermes Replica</a></div>
  </div>
</section>

<!-- PROGRAMS SECTION -->
<section id="programs" class="py-20 bg-gray-50">
  <div class="container mx-auto px-6">
    <h2 class="section-title text-3xl md:text-4xl font-bold text-center mb-12" data-aos="fade-up">Our Programs</h2>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
      
      <!-- Program 1 -->
      <div class="program-card bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-2xl transition duration-500" data-aos="fade-up" data-aos-delay="100">
        <img src="assets/edu.jpg" alt="Herbal Medicine Training" class="w-full h-48 object-cover">
        <div class="p-6">
          <h3 class="text-xl font-semibold mb-2">Education & Skills Development</h3>
          <p class="text-gray-700 mb-4">Empowering children, women, and youth through learning.</p>
          <a href="education.php" class="text-blue-400 font-semibold hover:underline">Learn More →</a>
        </div>
      </div>

      <!-- Program 2 -->
      <div class="program-card bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-2xl transition duration-500" data-aos="fade-up" data-aos-delay="200">
        <img src="assets/bg2.jpg" alt="Community Health Programs" class="w-full h-48 object-cover">
        <div class="p-6">
          <h3 class="text-xl font-semibold mb-2">Economic & Community Support</h3>
          <p class="text-gray-700 mb-4">Health education and support programs to improve wellness in local communities.</p>
          <a href="community-support.php" class="text-blue-400 font-semibold hover:underline">Learn More →</a>
        </div>
      </div>

      <!-- Program 3 -->
      <div class="program-card bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-2xl transition duration-500" data-aos="fade-up" data-aos-delay="300">
        <img src="assets/gbv1.jpg" alt="Women Empowerment" class="w-full h-48 object-cover">
        <div class="p-6">
          <h3 class="text-xl font-semibold mb-2">Addressing Gender-Based Violence</h3>
          <p class="text-gray-700 mb-4">Empowering women and girls to break free from cycles of abuse.</p>
          <a href="gbv.php" class="text-blue-400 font-semibold hover:underline">Learn More →</a>
        </div>
      </div>

      <!-- Program 4 -->
      <div class="program-card bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-2xl transition duration-500" data-aos="fade-up" data-aos-delay="300">
        <img src="assets/4.jpg" alt="Women Empowerment" class="w-full h-48 object-cover">
        <div class="p-6">
          <h3 class="text-xl font-semibold mb-2">Health and Well-being</h3>
          <p class="text-gray-700 mb-4">Promoting wellness and access to care for stronger communities</p>
          <a href="health.php" class="text-blue-400 font-semibold hover:underline">Learn More →</a>
        </div>
      </div>

      <!-- Program 5 -->
      <div class="program-card bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-2xl transition duration-500" data-aos="fade-up" data-aos-delay="300">
        <img src="assets/5.jpg" alt="Women Empowerment" class="w-full h-48 object-cover">
        <div class="p-6">
          <h3 class="text-xl font-semibold mb-2">Entrepreneurship</h3>
          <p class="text-gray-700 mb-4">Fostering entrepreneurship for self-reliance and growth.</p>
          <a href="entrepreneurship.php" class="text-blue-400 font-semibold hover:underline">Learn More →</a>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- IMPACT SECTION WITH COUNTERS -->
<section id="impact" class="py-20 bg-white">
  <div class="container mx-auto px-6 text-center">
    <h2 class="section-title text-3xl md:text-4xl font-bold mb-12" data-aos="fade-up">Our Impact</h2>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
      
      <!-- Impact 1 -->
      <div class="p-6 bg-gray-50 rounded-lg shadow-lg" data-aos="fade-up" data-aos-delay="100">
        <div class="text-5xl mb-4 text-blue-400"><i class="fa-solid fa-female"></i></div>
        <h3 class="text-xl font-semibold mb-2">Women Trained</h3>
        <p class="text-gray-700 text-lg font-medium"><span class="counter" data-target="500">0</span>+</p>
      </div>
      
      <!-- Impact 2 -->
      <div class="p-6 bg-gray-50 rounded-lg shadow-lg" data-aos="fade-up" data-aos-delay="200">
        <div class="text-5xl mb-4 text-blue-400"><i class="fa-solid fa-people-roof"></i></div>
        <h3 class="text-xl font-semibold mb-2">Communities Supported</h3>
        <p class="text-gray-700 text-lg font-medium"><span class="counter" data-target="20">0</span>+</p>
      </div>
      
      <!-- Impact 3 -->
      <div class="p-6 bg-gray-50 rounded-lg shadow-lg" data-aos="fade-up" data-aos-delay="300">
        <div class="text-5xl mb-4 text-blue-400"><i class="fa-solid fa-diagram-project"></i></div>
        <h3 class="text-xl font-semibold mb-2">Projects Completed </h3>
        <p class="text-gray-700 text-lg font-medium"><span class="counter" data-target="10">0</span>+</p>
      </div>
      
    </div>
  </div>
</section>

<!-- CTA SECTION -->
<section id="cta" class="py-20 bg-brand text-white">
  <div class="container mx-auto px-6 text-center">
    <h2 class="text-3xl md:text-4xl font-bold mb-6" data-aos="fade-up">Support Women Empowerment Today</h2>
    <p class="text-lg md:text-xl mb-8" data-aos="fade-up" data-aos-delay="100">
      Join Ekwendeni Women Dawa Organisation in empowering women, and strengthening communities across Northern Malawi.
    </p>
    <div class="flex flex-col md:flex-row justify-center items-center gap-4" data-aos="fade-up" data-aos-delay="200">
      <a href="donate.php" class="btn-primary px-8 py-4 text-lg md:text-xl">Donate Now</a>
      <a href="getinvolved.php" class="border border-white px-8 py-4 rounded text-white text-lg md:text-xl hover:bg-white hover:text-black transition">Get Involved</a>
    </div>
  </div>
</section>

<?php
    include 'footer.php';
?>