<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Website Suspended | Ozone Dynamics</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Tailwind CSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Alpine.js -->
  <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>

<body class="bg-slate-900 text-white min-h-screen flex items-center justify-center">

  <div 
    x-data="{ show: false }" 
    x-init="setTimeout(() => show = true, 150)"
    x-show="show"
    x-transition:enter="transition ease-out duration-700"
    x-transition:enter-start="opacity-0 translate-y-6"
    x-transition:enter-end="opacity-100 translate-y-0"
    class="max-w-lg w-full text-center px-6"
  >

    <!-- Icon -->
    <div class="flex justify-center mb-6">
      <div class="h-20 w-20 rounded-full bg-red-500/10 flex items-center justify-center">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
            d="M12 9v2m0 4h.01M5.07 19h13.86c1.54 0 2.5-1.67 1.73-3L13.73 4c-.77-1.33-2.69-1.33-3.46 0L3.34 16c-.77 1.33.19 3 1.73 3z" />
        </svg>
      </div>
    </div>

    <!-- Title -->
    <h1 class="text-3xl font-bold mb-4">
      Website Suspended
    </h1>

    <!-- Message -->
    <p class="text-slate-300 mb-6 leading-relaxed">
      This website has been temporarily suspended due to an administrative or billing issue.
      If you are the website owner, please contact support to restore access.
    </p>

    <!-- CTA -->
    <a
      href="mailto:ozonedynamics1@gmail.com"
      class="inline-flex items-center justify-center gap-2 px-6 py-3 bg-indigo-600 hover:bg-indigo-700 transition rounded-lg font-semibold shadow-lg"
    >
      Contact Ozone Dynamics Support
    </a>

    <!-- Footer -->
    <p class="mt-8 text-sm text-slate-500">
      © <span x-text="new Date().getFullYear()"></span> Ozone Dynamics
    </p>

  </div>

</body>
</html>
