<?php
    include 'header.php';
?>
  <!-- HERO SECTION -->
  <section class="hero-bg1 relative flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Latest News</h1>
      <p class="text-lg" data-aos="fade-up">Stay updated with our stories and activities.</p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.html" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold">News</li>
    </ol>
  </nav>

  <!-- NEWS SECTION -->
  <section id="news" class="py-20 bg-white">
    <div class="container mx-auto px-6">
      <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
        <?php 
          $news = $db->query("SELECT * FROM news ORDER BY id DESC");
          while($result = $news->fetch_assoc()):

            // Remove HTML tags
            $text = strip_tags($result['description']);

            // Replace newlines, tabs, and multiple spaces with a single space
            $text = preg_replace("/[\r\n\t]+/", ' ', $text);
            $text = preg_replace("/\s+/", ' ', $text); // collapse multiple spaces

            // Set character limit
            $limit = 150;

            // Truncate if longer than limit
            $excerpt = strlen($text) > $limit ? substr($text, 0, $limit) . '...' : $text;
        ?>
          <!-- News Item 1 -->
<a href="view-news.php?id=<?php echo $result['id']?>" 
   class="block bg-gray-50 rounded-xl shadow-lg overflow-hidden transform hover:scale-105 transition duration-500 group" 
   data-aos="fade-up">
  
  <!-- Image with hover zoom -->
  <div class="overflow-hidden">
    <img src="assets/1.jpg" 
         alt="News 1" 
         class="w-full h-56 object-cover transition-transform duration-500 group-hover:scale-110">
  </div>

  <div class="p-6">
    <!-- Date and Category -->
    <div class="flex items-center justify-between mb-2">
      <p class="text-sm text-gray-500">
        <?php echo date('d F, Y', strtotime($result['date'])) ?>
      </p>
      <span class="text-xs bg-blue-100 text-blue-700 font-semibold px-2 py-1 rounded-full">
        <?php echo $result['category']; ?>
      </span>
    </div>

    <!-- Title with hover color -->
    <h3 class="text-xl font-bold mb-3 text-gray-800 transition-colors duration-300 group-hover:text-blue-500">
      <?php echo $result['title']?>
    </h3>

    <!-- Short excerpt -->
    <p class="text-gray-600 mb-4"><?php echo $excerpt; ?></p>
  </div>
</a>
        <?php endwhile; ?>
      </div>
    </div>
  </section>
<?php
    include 'footer.php';
?>
