<?php
    include 'header.php';

    $event = $db->query("SELECT * FROM events WHERE id = " . intval($_GET['id']));
    $result = $event->fetch_assoc();
?>
  <!-- HERO -->
  <section class="relative h-64 flex items-center justify-center text-center text-white"
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('https://images.unsplash.com/photo-1593113598332-cd6f1b2b1fcb?auto=format&fit=crop&w=1400&q=80'); background-size:cover; background-position:center;">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down"><?php echo $result['title']?></h1>
      <p class="text-lg" data-aos="fade-up">📅 <?php echo date('d F, Y', strtotime($result['startDate'])) ?> • 📍 <?php echo $result['location']?></p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.php" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li><a href="events.php" class="hover:text-brand">Events</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold"><?php echo $result['title']?></li>
    </ol>
  </nav>

  <!-- EVENT DETAILS -->
<section class="py-20 bg-gradient-to-b from-blue-50 to-white">
  <div class="container mx-auto px-6 lg:flex lg:space-x-12">
    
    <!-- Event Content -->
    <div class="lg:w-2/3 mb-12 lg:mb-0" data-aos="fade-right">
      
      <!-- Event Banner -->
      <div class="relative rounded-2xl overflow-hidden shadow-lg mb-8">
        <img src="assets/1.jpg" alt="Event Banner" class="w-full h-full object-contain">
        <div class="absolute inset-0 bg-black bg-opacity-40 flex flex-col justify-end p-6">
          <p class="text-sm text-gray-200">📅 <?php echo date('d F, Y', strtotime($result['startDate'])) ?> • 📍 <?php echo $result['location']?></p>
          <!-- <h2 class="text-3xl md:text-4xl font-bold text-white"><?php echo $result['title']?></h2> -->
        </div>
      </div>

      <!-- Event Description -->
      <div class="space-y-5 text-lg text-gray-700">
        <?php echo $result['description']; ?>
      </div>

      <!-- CTA -->
      <a href="getinvolved.php" class="inline-block mt-8 px-6 py-3 rounded-lg bg-blue-600 text-white font-semibold hover:bg-blue-700 transition">
        Get Involved
      </a>
    </div>

    <!-- Event Sidebar -->
    <aside class="lg:w-1/3 space-y-6" data-aos="fade-left">
      
      <!-- Organizer -->
      <div class="bg-white rounded-2xl shadow-md p-6 hover:shadow-lg transition">
        <h3 class="font-bold text-xl mb-4 text-blue-600">Organizer</h3>
        <p class="text-gray-800 mb-2">Ekwendeni Women Dawa Organisation</p>
        <p class="text-gray-700 mb-2">📧 <a href="mailto:info@ewdomw.org" class="text-blue-600 hover:underline">info@ewdomw.org</a></p>
        <p class="text-gray-700">📞 +265 886 090 669</p>
      </div>

      <!-- Highlights -->
      <!-- <div class="bg-white rounded-2xl shadow-md p-6 hover:shadow-lg transition">
        <h3 class="font-bold text-xl mb-4 text-blue-600">Event Highlights</h3>
        <ul class="space-y-2 text-gray-700">
          <li class="flex items-center gap-2">
            <span class="text-blue-500">✔</span> Hands-on herbal medicine preparation
          </li>
          <li class="flex items-center gap-2">
            <span class="text-blue-500">✔</span> Income-generating skills for women
          </li>
          <li class="flex items-center gap-2">
            <span class="text-blue-500">✔</span> Community health discussions
          </li>
          <li class="flex items-center gap-2">
            <span class="text-blue-500">✔</span> Traditional medicine preservation
          </li>
        </ul>
      </div> -->

    </aside>
  </div>
</section>


<?php
    include 'footer.php';
?>
