<?php
    include 'header.php';

    $news = $db->query("SELECT * FROM news WHERE id = " . intval($_GET['id']));
    $result = $news->fetch_assoc();
?>
  <!-- HERO SECTION -->
  <section class="hero-bg1 relative flex items-center justify-center text-center text-white">
    <div>
      <h1 class="text-1xl md:text-2xl font-bold mb-2" data-aos="fade-down"><?php echo $result['title']; ?></h1>
      <p class="text-lg" data-aos="fade-up"></p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.php" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li><a href="news.php" class="hover:text-brand">News</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold"><?php echo $result['title']; ?></li>
    </ol>
  </nav>

  <!-- NEWS DETAIL -->
<section class="py-16 bg-white">
  <div class="container mx-auto px-6 md:flex md:space-x-10">
    
    <!-- Main Article -->
    <div class="md:w-2/3" data-aos="fade-right">
      <img src="assets/1.jpg" 
           alt="" class="w-full rounded-lg shadow-lg mb-6">
      <h2 class="text-3xl font-bold text-gray-800 mb-4"><?php echo $result['title']; ?></h2>
      
      <!-- Meta Info -->
      <div class="flex items-center text-sm text-gray-500 mb-6 space-x-4">
        <span>Published on <?php echo date('d F, Y', strtotime($result['date'])) ?></span>
        <span class="px-3 py-1 bg-brand/10 text-brand rounded-full text-xs font-semibold"><?php echo $result['category']; ?></span>
        <span class="text-gray-400">|</span>
        <span>By Ekwendeni Women Dawa Organisation</span>
      </div>

      <!-- Article Content -->
      <div class="prose max-w-none text-gray-700">
        <?php echo $result['description']; ?>
      </div>

      <!-- Share Section -->
      <div class="mt-8 border-t pt-6">
        <h4 class="text-lg font-semibold text-gray-800 mb-3">Share this article:</h4>
        <div class="flex space-x-4">
          <a href="#" class="w-10 h-10 flex items-center justify-center rounded-full bg-blue-600 text-white hover:bg-blue-700 transition">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a href="#" class="w-10 h-10 flex items-center justify-center rounded-full bg-sky-500 text-white hover:bg-sky-600 transition">
            <i class="fab fa-twitter"></i>
          </a>
          <a href="#" class="w-10 h-10 flex items-center justify-center rounded-full bg-red-600 text-white hover:bg-red-700 transition">
            <i class="fab fa-youtube"></i>
          </a>
          <a href="#" class="w-10 h-10 flex items-center justify-center rounded-full bg-green-600 text-white hover:bg-green-700 transition">
            <i class="fab fa-whatsapp"></i>
          </a>
        </div>
      </div>

      <!-- Back Button -->
      <div class="mt-8">
        <a href="news.php" class="btn-primary inline-block">← Back to News</a>
      </div>
    </div>

    <!-- Sidebar -->
    <aside class="md:w-1/3 mt-10 md:mt-0" data-aos="fade-left">
      <h3 class="text-xl font-bold mb-4 text-gray-800">Recent Posts</h3>
      <ul class="space-y-4">
        <?php
            $post = $db->query("SELECT * FROM news ORDER BY id DESC LIMIT 5");
            while($res = $post->fetch_assoc()):
        ?>
        <li>
          <a href="view-news.php" class="block hover:text-blue-500 bg-white p-6 rounded-lg shadow hover:shadow-lg transition flex items-start space-x-4">
            <?php echo $res['title']; ?> - <?php echo date('d F, Y', strtotime($res['date'])) ?>
          </a>
        </li>
        <?php endwhile; ?>
      </ul>
    </aside>

  </div>
</section>
<?php
    include 'footer.php'; 
?>
