<?php
    include 'header.php'; 
?>
    <style>
        
    input, textarea, select {border:1px solid #0ea5e9; padding:0.5rem; border-radius:0.5rem; width:100%;}
    </style>
  <!-- HERO -->
  <section class="relative h-64 flex items-center justify-center text-center text-white"
    style="background-image:linear-gradient(rgba(0,0,0,0.45), rgba(0,0,0,0.45)), url('https://images.unsplash.com/photo-1506784983877-45594efa4cbe?auto=format&fit=crop&w=1400&q=80'); background-size:cover; background-position:center;">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2" data-aos="fade-down">Get Involved</h1>
      <p class="text-lg" data-aos="fade-up">Join us in empowering women and strengthening communities</p>
    </div>
  </section>

  <!-- BREADCRUMB -->
  <nav class="bg-gray-100 py-3 px-6" aria-label="Breadcrumb">
    <ol class="flex items-center space-x-2 text-gray-600">
      <li><a href="index.html" class="hover:text-brand">Home</a></li>
      <li>/</li>
      <li class="text-gray-800 font-semibold">Get Involved</li>
    </ol>
  </nav>

  <!-- VOLUNTEER INFO SECTION -->
  <section class="py-20 bg-white">
    <div class="container mx-auto px-6 md:w-2/3">
      <h2 class="section-title text-3xl md:text-4xl font-bold text-center mb-12">Volunteer With Us</h2>
      <p class="text-gray-700 text-lg mb-8 text-center" data-aos="fade-up">
        Ekwendeni Women Dawa Organisation welcomes passionate individuals who want to make a difference in the lives of women and communities in Northern Malawi. Whether you have expertise in education, health, or community development, your contribution matters.
      </p>

      <p class="text-gray-700 text-lg mb-12 text-center" data-aos="fade-up" data-aos-delay="100">
        Volunteers will participate in training sessions, workshops, community outreach programs, and events that empower women and support community programs.
      </p>

      <!-- Volunteer Form -->
      <form class="bg-gray-50 p-8 rounded-xl shadow-lg" data-aos="fade-up" data-aos-delay="200">
        <div class="grid md:grid-cols-2 gap-6 mb-6">
          <div>
            <label class="block font-semibold mb-2 text-gray-700">Full Name</label>
            <input type="text" name="name" placeholder="Your Name" required>
          </div>
          <div>
            <label class="block font-semibold mb-2 text-gray-700">Email</label>
            <input type="email" name="email" placeholder="you@example.com" required>
          </div>
        </div>

        <div class="grid md:grid-cols-2 gap-6 mb-6">
          <div>
            <label class="block font-semibold mb-2 text-gray-700">Phone</label>
            <input type="text" name="phone" placeholder="+265 999 123 456">
          </div>
          <div>
            <label class="block font-semibold mb-2 text-gray-700">Area of Interest</label>
            <select name="interest" required>
              <option value="">Select Area</option>
              <option value="Education & Skills Development">Education & Skills Development</option>
              <option value="Economic & Community Support">Economic & Community Support</option>
              <option value="Addressing Gender-Based Violence">Addressing Gender-Based Violence</option>
              <option value="Entrepreneurship">Entrepreneurship</option>
              <option value="Health and Well-being">Health and Well-being</option>
            </select>
          </div>
        </div>

        <div class="mb-6">
          <label class="block font-semibold mb-2 text-gray-700">Message</label>
          <textarea name="message" rows="4" placeholder="Tell us why you want to volunteer"></textarea>
        </div>

        <div class="text-center">
          <button type="submit" class="btn-primary w-full md:w-auto">Submit</button>
        </div>
      </form>
    </div>
  </section>
<?php
    include 'footer.php';
?>
